C
C------------------------------------------------------
C
C     Problem:    HOMPOLY
C
C     Date:       1.02.2001
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      MBAR=4
      IBAR=4
      TEMPBAR=0.9
      M0=0
      I0=0
      T0=0
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      E1, E2, TEMP, M, I, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION TEMPP
      IF (T.LE.2) THEN
        F=0
      ELSE
        F=0.02
      ENDIF
      FACTOR1=EXP((E2*TEMP/(1+TEMP)))*SQRT(I+1)*(M+1)
      TEMPP=((T0+1)*TEMPBAR-(TEMP+1))*(F+1)+(1-TEMPBAR)*FACTOR1
C
*     FUNCTION MP
      MP=((M0+1)*MBAR-(M+1))*(F+1)+(1-MBAR)*FACTOR1
C
*     FUNCTION IP
      FACTOR2=EXP(E1*TEMP/(1+TEMP))
      IP=((I0+1)*IBAR-(I+1))*(F+1)+(1-IBAR)*(I+1)*FACTOR2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION TEMP_0
      IF (T.LT.0.001) THEN
        TEMP_0 = T0  
      ELSE
        TEMP_0 = TEMP
      ENDIF
C
*     FUNCTION M_0
      IF (T.LT.0.001) THEN
        M_0 = M0 
      ELSE
        M_0 = M
      ENDIF
C
*     FUNCTION I_0
      IF (T.LT.0.001) THEN
        I_0 = I0
      ELSE
        I_0 = I
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X
      X=((M+1)/SQRT(I+1))*EXP((E2-E1)*TEMP/(1+TEMP))-1
C
*     FUNCTION TEMP_SIM
      TEMP_SIM=TEMP
C
*     FUNCTION M_SIM
      M_SIM=M
C
*     FUNCTION I_SIM
      I_SIM=I
C
C-----------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
