C
C------------------------------------------------------
C
C     Problem:    HOLDUP
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      L0=13.05
      M=0.7605  
      N=2.805E-2
      H=0.2      
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Z0, Z, Z8, H1, H2, H3, H4, H5, H6, H7, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION H1P
      IF (T.LE.4) THEN
        G0=10.5
      ELSE
        G0=12
      ENDIF
      G1=H1**M/N  
      G2=H2**M/N  
      G3=H3**M/N  
      G4=H4**M/N  
      G5=H5**M/N  
      G6=H6**M/N  
      G7=H7**M/N  
      G8=G0   
      L1=L0+G2-G1 
      L2=L1+G3-G2 
      L3=L2+G4-G3 
      L4=L3+G5-G4 
      L5=L4+G6-G5 
      L6=L5+G7-G6 
      L7=L6+G8-G7 
      H1P=(G2-G1)/Z0  
C
*     FUNCTION H2P
      H2P=(G3-G2)/Z   
C
*     FUNCTION H3P
      H3P=(G4-G3)/Z   
C
*     FUNCTION H4P
      H4P=(G5-G4)/Z   
C
*     FUNCTION H5P
      H5P=(G6-G5)/Z   
C
*     FUNCTION H6P
      H6P=(G7-G6)/Z   
C
*     FUNCTION H7P
      H7P=(G8-G7)/Z8  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION H1_0
      IF (T.LT.0.1) THEN
        H1_0=H
      ELSE
        H1_0=H1
      ENDIF
C
*     FUNCTION H2_0
      IF (T.LT.0.1) THEN
        H2_0=H
      ELSE
        H2_0=H2
      ENDIF
C
*     FUNCTION H3_0
      IF (T.LT.0.1) THEN
        H3_0=H
      ELSE
        H3_0=H3
      ENDIF
C
*     FUNCTION H4_0
      IF (T.LT.0.1) THEN
        H4_0=H
      ELSE
        H4_0=H4
      ENDIF
C
*     FUNCTION H5_0
      IF (T.LT.0.1) THEN
        H5_0=H
      ELSE
        H5_0=H5
      ENDIF
C
*     FUNCTION H6_0
      IF (T.LT.0.1) THEN
        H6_0=H
      ELSE
        H6_0=H6
      ENDIF
C
*     FUNCTION H7_0
      IF (T.LT.0.1) THEN
        H7_0=H
      ELSE
        H7_0=H7
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION H1_fit
      H1_fit=H1
C
*     FUNCTION H2_fit
      H2_fit=H2
C
*     FUNCTION H3_fit
      H3_fit=H3
C
*     FUNCTION H4_fit
      H4_fit=H4
C
*     FUNCTION H5_fit
      H5_fit=H5
C
*     FUNCTION H6_fit
      H6_fit=H6
C
*     FUNCTION H7_fit
      H7_fit=H7
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
