C
C------------------------------------------------------
C
C     Problem:    HTM
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      M0=1000
      XF0=0.42
      TEMPI=50
      TC=25
      XA0=0.25
      TEMP0=25
      TEMPMAX=100
      HR=1100
      U=415
      A=1
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      CP, W, M, TEMP, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION M_t
      IF (t.GT.45) THEN
        W1=W/2
      ELSE
        W1=W
      ENDIF
      M_t=W1
C
*     FUNCTION TEMP_t
      Q=U*A*(TEMP-TC)
      TEMP_t=(W1*CP*(TEMP0-TEMP)+W1*XA0*HR-Q)/(M*CP)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION M_0
      IF (t.LT.1) THEN
        M_0=M0
      ELSE
        M_0=M
      ENDIF
C
*     FUNCTION TEMP_0
      IF (t.LT.1) THEN
        TEMP_0=TEMPI
      ELSE
        TEMP_0=TEMP
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION M_fit
      M_fit=M
C
*     FUNCTION TEMP_fit
      TEMP_fit=TEMP
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
