C
C------------------------------------------------------
C
C     Problem:    HIV
C
C     Date:       27.01.2004
C
C------------------------------------------------------
C                                           
*     REAL CONSTANT
      lambda = 0.3
      betap = 0.82
      sigma = 1.5
C
C------------------------------------------------------
C      
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, mu, beta, x, y1, y2, z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      x_t = (lambda - k1 - beta - mu)*x + lambda*sigma*(y1 + y2)
     /      - k2*x*(y1 + y2)/(x + y1 + y2)
C
*     FUNCTION y1_t
      y1_t = (-mu - betap)*y1 + k2*x*(y1 + y2)/(x + y1 + y2)
C
*     FUNCTION y2_t
      y2_t = (-mu - betap)*y2 + k1*x
C
*     FUNCTION z_t
      z_t = beta*x + beta*(y1 + y2) - mu*z
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 250
C
*     FUNCTION y1_0
      y1_0 = 26
C
*     FUNCTION y2_0
      y2_0 = 68
C
*     FUNCTION z_0
      z_0 = 3
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION z_fit
      z_fit = z
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
