C
C------------------------------------------------------
C
C     Problem:    HIRUDIN
C
C     Date:       9.8.1999
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, cE0, cL0, cF0, cEL0, cFL0
      cE, cL, cF, cEL, cFL, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION cE_t
      cE_t = k1*cE*cL + k2*cEL
C
*     FUNCTION cL_t
      cL_t = k3*cL*cF + k4*cFL
C
*     FUNCTION cF_t
      cF_t = k3*cL*cF + k4*cFL
C
*     FUNCTION cEL_t
      cEL_t = k1*cE*cL + k2*cEL
C
*     FUNCTION cFL_t
      cFL_t = k3*cL*cF + k4*cFL
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION cE_0
      cE_0 = cE0
C
*     FUNCTION cL_0
      cL_0 = cL0
C
*     FUNCTION cF_0
      cF_0 = cF0
C
*     FUNCTION cEL_0
      cEL_0 = cEL0
C
*     FUNCTION cFL_0
      cFL_0 = cFL0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION cE_fit
      cE_fit = cE
C
*     FUNCTION cL_fit
      cL_fit = cL
C
*     FUNCTION cF_fit
      cF_fit = cF
C
*     FUNCTION cEL_fit
      cEL_fit = cEL
C
*     FUNCTION cFL_fit
      cFL_fit = cFL
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = cE
C
*     FUNCTION g2
      g2 = cL
C
*     FUNCTION g3
      g3 = cF
C
*     FUNCTION g4
      g4 = cEL
C
*     FUNCTION g5
      g5 = cFL
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



