C
C------------------------------------------------------
C
C     Problem:    HIRES_PA
C
C     Date:       15.05.2007
C
C------------------------------------------------------
C
*     REAL CONSTANT
      D   = 0.0057
      K3  = 6.23
      K4  = 6.27
      K5  = 4.63
      K9  = 1.57E+02
      K10 = 1.39
      K11 = 3.75
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, K6, K7, K8
      Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P = -K1*Y1 + K2*Y2 + K3*Y3 + 0.0007
C
*     FUNCTION Y2P
      Y2P = K1*Y1 - K4*Y2
C
*     FUNCTION Y3P
      Y3P = -K5*Y3 + K2*Y4 + K6*Y5
C
*     FUNCTION Y4P
      Y4P = K3*Y2 + K1*Y3 - K7*Y4
C
*     FUNCTION Y5P
      Y5P = -K8*Y5 + K2*Y6 + K2*Y7
C
*     FUNCTION Y6P
      Y6P = -K9*Y6*Y8 + K10*Y4 + K1*Y5 - K2*Y6 + K10*Y7
C
*     FUNCTION Y7P
      Y7P = K9*Y6*Y8 - K11*Y7
C
*     FUNCTION Y8P
      Y8P = -Y7P
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = 1
C
*     FUNCTION Y20
      Y20 = 0
C
*     FUNCTION Y30
      Y30 = 0
C
*     FUNCTION Y40
      Y40 = 0
C
*     FUNCTION Y50
      Y50 = 0
C
*     FUNCTION Y60
      Y60 = 0
C
*     FUNCTION Y70
      Y70 = D
C
*     FUNCTION Y80
      Y80 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT = Y2
C
*     FUNCTION Y2FIT
      Y2FIT = Y5
C
*     FUNCTION Y3FIT
      Y3FIT = Y7
C
*     FUNCTION Y4FIT
      Y4FIT = Y8
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g
C      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





