C
C------------------------------------------------------
C
C     Problem:    HIGH_ORD
C
C     Date:       12.06.2001
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..6
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      ya, y, y1, y2, y3, y4, y5, y6, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y_t
      y_t = y1
C
*     FUNCTION y1_t
      y1_t = y2
C
*     FUNCTION y2_t
      y2_t = y3
C
*     FUNCTION y3_t
      y3_t = y4
C
*     FUNCTION y4_t
      y4_t = y5
C
*     FUNCTION y5_t
      y5_t = y6
C
*     FUNCTION y6_t
      y6_t = -y5  - y1 - 0.001*y
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y_0
      y_0 = ya
C
*     FUNCTION y0(i), i in ind
      y0(i) = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y_fit
      y_fit = y
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y4_fit = y4
C
*     FUNCTION y5_fit
      y5_fit = y5
C
*     FUNCTION y6_fit
      y6_fit = y6
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

