C
C------------------------------------------------------
C
C     Problem:    HEXA
C
C     Date:       14.05.2004
C
C------------------------------------------------------
C              
*     REAL CONSTANT
      rho = 1000
      pi = 3.1415926535
C
C------------------------------------------------------
C              
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      c33, c11, c44, c13, phi0, x
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION vlong
      phi = (x - phi0)/360.0*2.0*pi
      main = c11*sin(phi)**2 + c33*cos(phi)**2 + c44
      mixed = sqrt(((c11-c44)*sin(phi)**2 
     /        + (c44-c33)*cos(phi)**2)**2  
     /        + (2*(c13+c44)*sin(phi)*cos(phi))**2) 
      vlong  = sqrt(1/2/rho*1e9*(main + mixed))
C
*     FUNCTION vtrans
      vtrans = sqrt(1/2/rho*1e9*(main - mixed))
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
