C
C------------------------------------------------------
C
C     Problem:    HEAT_SEN
C
C     Date:       22.12.97
C
C------------------------------------------------------
C
*     PARAMETER
      n = 9
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D, p, r
      u, JD, Jp, Jr
      u_x, JD_x, Jp_x, Jr_x
      u_xx, JD_xx, Jp_xx, Jr_xx 
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u_t
      u_t = p*u_xx
C
*     FUNCTION JD_t
      JD_t = p*JD_xx 
C
*     FUNCTION Jp_t
      Jp_t = p*Jp_xx + u_xx 
C
*     FUNCTION Jr_t
      Jr_t = p*Jr_xx 
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u_0
      u_0 = D*sin(pi*x) + r
C
*     FUNCTION JD_0
      JD_0 = sin(pi*x)
C
*     FUNCTION Jp_0
      Jp_0 = 0
C
*     FUNCTION Jr_0
      Jr_0 = 1
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u_left
      u_left = r
C
*     FUNCTION JD_left
      JD_left = 0
C
*     FUNCTION Jp_left
      Jp_left = 0
C
*     FUNCTION Jr_left
      Jr_left = 1
C
*     FUNCTION u_right
      u_right = r
C
*     FUNCTION JD_right
      JD_right = 0
C
*     FUNCTION Jp_right
      Jp_right = 0
C
*     FUNCTION Jr_right
      Jr_right = 1
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit0
      fit0 = u
C
*     FUNCTION fit1
      fit1 = Jp
C
*     FUNCTION a1
      a1 = u - D*exp(-p*t*pi**2)*sin(x*pi) - r
C
*     FUNCTION b1
      b1 = JD - exp(-p*t*pi**2)*sin(x*pi)
C
*     FUNCTION c1
      c1 = Jp + D*t*pi**2*exp(-p*t*pi**2)*sin(x*pi)
C
*     FUNCTION d1
      d1 = Jr - 1
C
*     FUNCTION fit2
      fit2 = Jp
C
*     FUNCTION a2
      a2 = u - D*exp(-p*t*pi**2)*sin(x*pi) - r
C
*     FUNCTION b2
      b2 = JD - exp(-p*t*pi**2)*sin(x*pi)
C
*     FUNCTION c2
      c2 = Jp + D*t*pi**2*exp(-p*t*pi**2)*sin(x*pi)
C
*     FUNCTION d2
      d2 = Jr - 1
C
*     FUNCTION fit3
      fit3 = Jp
C
*     FUNCTION a3
      a3 = u - D*exp(-p*t*pi**2)*sin(x*pi) - r
C
*     FUNCTION b3
      b3 = JD - exp(-p*t*pi**2)*sin(x*pi)
C
*     FUNCTION c3
      c3 = Jp + D*t*pi**2*exp(-p*t*pi**2)*sin(x*pi)
C
*     FUNCTION d3
      d3 = Jr - 1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



