C
C------------------------------------------------------
C
C     Problem:    HEAT_NLD
C
C     Date:       24.10.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      e1 = exp(1/3)
      e2 = exp(2/3)
C
C------------------------------------------------------
C
*     MACRO u
      if (t.le.t1) then
        u = 0
      else
        if (t.lt.t2) then
          u = (t-t1)/(t2-t1)
        else
          u = 1
        endif
      endif
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      t1, t2, y, y_x, y_xx, v, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION y_t
      y_t = y_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION y_0
      if (t.lt.t1) then
        y_0 = cos(x)
      else
        y_0 = y
      endif
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION equ
      e = 0.25*exp(-4*t) - (exp(t) - e1)/(e2 - e1)
      equ = u + e - y**4 - v
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION v_0
      v_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
C*     FUNCTION y_left
C      y_left = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C
*     FUNCTION y_x_left
      y_x_left = 0
C
*     FUNCTION y_x_right
      y_x_right = v
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      fit = y - exp(-t)*cos(x)
C
*     FUNCTION sim
      sim = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g
      g = t2 - t1 - 0.00001
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





