C
C------------------------------------------------------
C
C     Problem:    HEAT_CYL
C
C     Date:       10.8.1996
C
C------------------------------------------------------
C
*     SET OF INDICES
      IND = 1..5
C
C------------------------------------------------------
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      D, a, u, u_r, u_rr, f, f_r, r, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION flux
      flux = D*r*u_r
C
*     FUNCTION u_t 
      if (r.gt.0) then
        u_t = f_r/r
      else
        u_t = 0
      endif    
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = 600.0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
C*     FUNCTION VP
C      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
C*     FUNCTION V0
C      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition derivatives first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION ux_left
      ux_left = 0.0
C
*     FUNCTION ux_right
      ux_right = a*1.0E-9*(6.25E+10 - u**4)
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit(I), I IN IND
      u_fit(I) = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
