C
C------------------------------------------------------
C
C     Problem:    HEATEX
C
C     Date:       13.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      HTM=20
      HMS=20            
      DT=5E-2
      DM=7.5E-2
      DS=0.1 
      L=2                       
C      CPT=2
C      CPM=1
C      CPS=2       
      FT=7.5E-3
      FS=1.5E-2     
      TS9=293
      TEMP0=293                  
      RT=1500
      RM=5000
      RS=1000  
      PI=3.1427  
      AT=PI*DT*L  
      AM=PI*DM*L  
      VT=PI*DT*DT*L/4   
      VM=PI*(DM*DM-DT*DT)*L/4   
      VS=PI*(DS*DS-DM*DM)*L/4 
      UTM=HTM*AT
      UMS=HMS*AM
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      CPT, CPM, CPS
      TT1, TT2, TT3, TT4, TT5, TT6, TT7, TT8
      TM1, TM2, TM3, TM4, TM5, TM6, TM7, TM8
      TS1, TS2, TS3, TS4, TS5, TS6, TS7, TS8
      T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION TT1P
      TT0=375
      IF (T.LE.21) THEN
        TT0=400
      ENDIF
      YT=CPT*VT*RT 
      ZT=FT/VT
      YM=CPM*VM*RS 
      ZS=FS/VS
      YS=CPS*VS*RS 
      QT1=UTM*(TT1-TM1)   
      QT2=UTM*(TT2-TM2)
      QT3=UTM*(TT3-TM3)
      QT4=UTM*(TT4-TM4)
      QT5=UTM*(TT5-TM5)
      QT6=UTM*(TT6-TM6)
      QT7=UTM*(TT7-TM7)
      QT8=UTM*(TT8-TM8)
      QM1=UMS*(TM1-TS1)   
      QM2=UMS*(TM2-TS2)
      QM3=UMS*(TM3-TS3)
      QM4=UMS*(TM4-TS4)
      QM5=UMS*(TM5-TS5)
      QM6=UMS*(TM6-TS6)
      QM7=UMS*(TM7-TS7)
      QM8=UMS*(TM8-TS8)
      TT1P=ZT*(TT0-0.5*(TT1+TT2))-QT1/YT   
C
*     FUNCTION TT2P
      TT2P=ZT*(TT1-TT2)-QT2/YT
C
*     FUNCTION TT3P
      TT3P=ZT*(TT2-TT3)-QT3/YT
C
*     FUNCTION TT4P
      TT4P=ZT*(TT3-TT4)-QT4/YT
C
*     FUNCTION TT5P
      TT5P=ZT*(TT4-TT5)-QT5/YT
C
*     FUNCTION TT6P
      TT6P=ZT*(TT5-TT6)-QT6/YT
C
*     FUNCTION TT7P
      TT7P=ZT*(TT6-TT7)-QT7/YT
C
*     FUNCTION TT8P
      TT9=TT8-0.5*(TT7-TT8)
      TT8P=ZT*(0.5*(TT7+TT8)-TT9)-QT8/YT
C
*     FUNCTION TM1P
      TM1P=(QT1-QM1)/YM
C
*     FUNCTION TM2P
      TM2P=(QT2-QM2)/YM
C
*     FUNCTION TM3P
      TM3P=(QT3-QM3)/YM
C
*     FUNCTION TM4P
      TM4P=(QT4-QM4)/YM
C
*     FUNCTION TM5P
      TM5P=(QT5-QM5)/YM
C
*     FUNCTION TM6P
      TM6P=(QT6-QM6)/YM
C
*     FUNCTION TM7P
      TM7P=(QT7-QM7)/YM
C
*     FUNCTION TM8P
      TM8P=(QT8-QM8)/YM
C
*     FUNCTION TS1P
      TS0=TS1+0.5*(TS1-TS2)   
      TS1P=ZS*(0.5*(TS1+TS2)-TS0)+QM1/YS   
C
*     FUNCTION TS2P
      TS2P=ZS*(TS3-TS2)+QM2/YS
C
*     FUNCTION TS3P
      TS3P=ZS*(TS4-TS3)+QM3/YS
C
*     FUNCTION TS4P
      TS4P=ZS*(TS5-TS4)+QM4/YS
C
*     FUNCTION TS5P
      TS5P=ZS*(TS6-TS5)+QM5/YS
C
*     FUNCTION TS6P
      TS6P=ZS*(TS7-TS6)+QM6/YS
C
*     FUNCTION TS7P
      TS7P=ZS*(TS8-TS7)+QM7/YS
C
*     FUNCTION TS8P
      TS8P=ZS*(TS9-0.5*(TS7+TS8))+QM8/YS
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION TT1_0
      IF (T.LT.0.1) THEN
        TT1_0=TEMP0
      ELSE
        TT1_0=TT1
      ENDIF
C
*     FUNCTION TT2_0
      IF (T.LT.0.1) THEN
        TT2_0=TEMP0
      ELSE
        TT2_0=TT2
      ENDIF
C
*     FUNCTION TT3_0
      IF (T.LT.0.1) THEN
        TT3_0=TEMP0
      ELSE
        TT3_0=TT3
      ENDIF
C
*     FUNCTION TT4_0
      IF (T.LT.0.1) THEN
        TT4_0=TEMP0
      ELSE
        TT4_0=TT4
      ENDIF
C
*     FUNCTION TT5_0
      IF (T.LT.0.1) THEN
        TT5_0=TEMP0
      ELSE
        TT5_0=TT5
      ENDIF
C
*     FUNCTION TT6_0
      IF (T.LT.0.1) THEN
        TT6_0=TEMP0
      ELSE
        TT6_0=TT6
      ENDIF
C
*     FUNCTION TT7_0
      IF (T.LT.0.1) THEN
        TT7_0=TEMP0
      ELSE
        TT7_0=TT7
      ENDIF
C
*     FUNCTION TT8_0
      IF (T.LT.0.1) THEN
        TT8_0=TEMP0
      ELSE
        TT8_0=TT8
      ENDIF
C
*     FUNCTION TM1_0
      IF (T.LT.0.1) THEN
        TM1_0=TEMP0
      ELSE
        TM1_0=TM1
      ENDIF
C
*     FUNCTION TM2_0
      IF (T.LT.0.1) THEN
        TM2_0=TEMP0
      ELSE
        TM2_0=TM2
      ENDIF
C
*     FUNCTION TM3_0
      IF (T.LT.0.1) THEN
        TM3_0=TEMP0
      ELSE
        TM3_0=TM3
      ENDIF
C
*     FUNCTION TM4_0
      IF (T.LT.0.1) THEN
        TM4_0=TEMP0
      ELSE
        TM4_0=TM4
      ENDIF
C
*     FUNCTION TM5_0
      IF (T.LT.0.1) THEN
        TM5_0=TEMP0
      ELSE
        TM5_0=TM5
      ENDIF
C
*     FUNCTION TM6_0
      IF (T.LT.0.1) THEN
        TM6_0=TEMP0
      ELSE
        TM6_0=TM6
      ENDIF
C
*     FUNCTION TM7_0
      IF (T.LT.0.1) THEN
        TM7_0=TEMP0
      ELSE
        TM7_0=TM7
      ENDIF
C
*     FUNCTION TM8_0
      IF (T.LT.0.1) THEN
        TM8_0=TEMP0
      ELSE
        TM8_0=TM8
      ENDIF
C
*     FUNCTION TS1_0
      IF (T.LT.0.1) THEN
        TS1_0=TEMP0
      ELSE
        TS1_0=TS1
      ENDIF
C
*     FUNCTION TS2_0
      IF (T.LT.0.1) THEN
        TS2_0=TEMP0
      ELSE
        TS2_0=TS2
      ENDIF
C
*     FUNCTION TS3_0
      IF (T.LT.0.1) THEN
        TS3_0=TEMP0
      ELSE
        TS3_0=TS3
      ENDIF
C
*     FUNCTION TS4_0
      IF (T.LT.0.1) THEN
        TS4_0=TEMP0
      ELSE
        TS4_0=TS4
      ENDIF
C
*     FUNCTION TS5_0
      IF (T.LT.0.1) THEN
        TS5_0=TEMP0
      ELSE
        TS5_0=TS5
      ENDIF
C
*     FUNCTION TS6_0
      IF (T.LT.0.1) THEN
        TS6_0=TEMP0
      ELSE
        TS6_0=TS6
      ENDIF
C
*     FUNCTION TS7_0
      IF (T.LT.0.1) THEN
        TS7_0=TEMP0
      ELSE
        TS7_0=TS7
      ENDIF
C
*     FUNCTION TS8_0
      IF (T.LT.0.1) THEN
        TS8_0=TEMP0
      ELSE
        TS8_0=TS8
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION TT1_fit
      TT1_fit=TT1
C
*     FUNCTION TT2_fit
      TT2_fit=TT2
C
*     FUNCTION TT3_fit
      TT3_fit=TT3
C
*     FUNCTION TT4_fit
      TT4_fit=TT4
C
*     FUNCTION TT5_fit
      TT5_fit=TT5
C
*     FUNCTION TT6_fit
      TT6_fit=TT6
C
*     FUNCTION TT7_fit
      TT7_fit=TT7
C
*     FUNCTION TT8_fit
      TT8_fit=TT8
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

