C
C------------------------------------------------------
C
C     Problem:    HAMILTON
C
C     Date:       14.10.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      a = 0.1
      b = 0.1
      x0 = 0.1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      q0, p10, p20, x, xa, q, p1, p2, p3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      x_t = -a*x - b*x**2 - p1/q
C
*     FUNCTION xa_t
      xa_t = -x - a*xa - 2*b*x*xa
C
*     FUNCTION q_t
      q_t = 0
C
*     FUNCTION p1_t
      p1_t = (a + 2*b*x)*p1 + (1 + 2*b*xa)*p2
C
*     FUNCTION p2_t
      p2_t = xa + (a + 2*b*x)*p2
C
*     FUNCTION p3_t
      p3_t = -p1**2/(2*q**2)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = x0
C
*     FUNCTION xa_0
      xa_0 = 0
C
*     FUNCTION q_0
      q_0 = q0
C
*     FUNCTION p1_0
      p1_0 = p10
C
*     FUNCTION p2_0
      p2_0 = p20
C
*     FUNCTION p3_0
      p3_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION E_fit
      E_fit = -p3*2
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION xa_fit
      xa_fit = xa
C
*     FUNCTION q_fit
      q_fit = q
C
*     FUNCTION p1_fit
      p1_fit = p1
C
*     FUNCTION p2_fit
      p2_fit = p2
C
*     FUNCTION p3_fit
      p3_fit = p3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = p1
C
*     FUNCTION g2
      g2 = p2
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
