C
C------------------------------------------------------
C
C     Problem:    GYROSCOP
C
C     Date:       20.11.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      a = 1
      b = 0.5
      c = 2
      d = 2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      I1, I3, phi, psi, theta, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION phi_p
      if (sin(theta).ne.0) then
        phi_p = (b - a*cos(theta))/sin(theta)**2
      else
        phi_p = 0
      endif
C
*     FUNCTION psi_p
      if (sin(theta).ne.0) then
        psi_p = a*I1/I3 - cos(theta)
     /                *(b-a*cos(theta))/sin(theta)**2
      else
        psi_p = 0
      endif
C
*     FUNCTION theta_p
      if (sin(theta).ne.0) then
        theta_p = sqrt(abs((c - d*cos(theta)) -
     /         ((b - a*cos(theta))/sin(theta))**2))
      else
        theta_p = 0
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION phi_0
      phi_0 = 0
C
*     FUNCTION psi_0
      psi_0 = 0
C
*     FUNCTION theta_0
      theta_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION phi_fit
      phi_fit = phi
C
*     FUNCTION psi_fit
      psi_fit = psi
C
*     FUNCTION theta_fit
      theta_fit = theta
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

