C
C------------------------------------------------------
C
C     Problem:    GYROS
C
C     Date:       17.10.99
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, c, q1, q2, q3, q4, om1, om2, om3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION q1_t
      q1_t = (q4*om1 - q3*om2 + q2*om3)*0.5 
C
*     FUNCTION q2_t
      q2_t = (q3*om1 + q4*om2 - q1*om3)*0.5 
C
*     FUNCTION q3_t
      q3_t = (-q2*om1 + q1*om2 + q4*om3)*0.5 
C
*     FUNCTION q4_t
      q4_t = -(q1*om1 + q2*om2 + q3*om3)*0.5 
C
*     FUNCTION om1_t
      om1_t = (b - c)/a*om2*om3
C
*     FUNCTION om2_t
      om2_t = (c - a)/b*om1*om3
C
*     FUNCTION om3_t
      om3_t = (a - b)/c*om1*om2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION q1_0
      q1_0 = sqrt((1 - cos(0.1))*0.5)
C
*     FUNCTION q2_0
      q2_0 = 0
C
*     FUNCTION q3_0
      q3_0 = 0
C
*     FUNCTION q4_0
      q4_0 = sqrt((1 + cos(0.1))*0.5)
C
*     FUNCTION om1_0
      om1_0 = 0
C
*     FUNCTION om2_0
      om2_0 = 1
C
*     FUNCTION om3_0
      om3_0 = 20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION balance
      balance = q1**2 + q2**2 + q3**2 + q4**2 - 1
C
*     FUNCTION q1_fit
      q1_fit = q1
C
*     FUNCTION q2_fit
      q2_fit = q2
C
*     FUNCTION q3_fit
      q3_fit = q3
C
*     FUNCTION q4_fit
      q4_fit = q4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION g
c      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
