C
C------------------------------------------------------
C
C     Problem:   GROUND_W
C
C     Date:      19.04.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      EPS=0.001
C
C------------------------------------------------------
C
*     LININT AW
      15.0 -14.8941
      40.0 -12.4942
      70.0 -11.6868
C
*     LININT RBL
      0.0000  -14.8941
      0.1661  -15.4185
      0.3327  -15.9429
      0.4994  -16.4673
      0.6661  -16.9755
      0.8327  -17.5000
      0.9994  -17.7745
      1.1661  -18.2908
      1.3327  -18.5654
      1.4991  -18.8399
      1.6661  -19.1063
      1.8327  -19.3645
      1.9994  -19.8891
      2.1661  -20.1556
      2.3327  -20.4220
      2.4994  -20.7048
      2.6661  -20.9631
      2.8327  -21.2295
      2.9994  -21.4960
      3.1661  -21.5124
      3.3327  -21.7871
      3.4991  -22.0454
      3.6661  -22.3201
      3.8327  -22.3365
      3.9994  -22.6030
      4.1661  -22.8778
      4.3327  -22.8860
      4.4994  -23.4109
      4.6661  -23.6692
      4.8327  -23.9358
C
*     LININT RBR
      0.0000  -11.6868
      0.1661  -12.4372
      0.3324  -12.9375
      0.4991  -13.6780
      0.6658  -13.9281
      0.8325  -14.6686
      0.9991  -14.9287
      1.1658  -15.6790
      1.3324  -15.9192
      1.4991  -16.1693
      1.6661  -16.4195
      1.8327  -17.1598
      1.9994  -17.1598
      2.1661  -17.4100
      2.3325  -17.6601
      2.4991  -17.9102
      2.6658  -18.1503
      2.8324  -18.4104
      2.9991  -18.6505
      3.1658  -18.6505
      3.3324  -19.4008
      3.4991  -19.4008
      3.6661  -19.3908
      3.8327  -19.6409
      3.9994  -19.6409
      4.1661  -19.8910
      4.3327  -20.1411
      4.4991  -20.1310
      4.6658  -20.3811
      4.8324  -20.3811
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      TR,TS,ALPHA,N,KS,U,UX,UXX,X,T
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION UP
      IF (U.LT.0.0) THEN
        AU=-ALPHA*U
        C=(TS-TR)*(1-1/N)*(1/(1+AU**N))**(-1/N)
     /     *(ALPHA*N*AU**(N-1))/(1+AU**N)**2
        GX=(1-1/N)/2*(1/(1+AU**N))**((1-1/N)/2-1)*
     /    (-N*AU**(N-1)*(-ALPHA*UX))/((1+AU**N)**2)*
     /    (1-(AU**N/(1+AU**N))**(1-1/N))**2*KS+
     /    2*KS*(1/(1+AU**N))**((1-1/N)/2)*
     /    (1-(AU**N/(1+AU**N))**(1-1/N))*
     /    (1/N-1)*(AU**N/(1+AU**N))**(-1/N)*
     /    (N*AU**(N-1)*(-ALPHA*UX))/((1+AU**N)**2)
        G=KS*(1/(1+AU**N))**((1-1/N)/2)*
     /    (1-(AU**N/(1+AU**N))**(1-1/N))**2
      ELSE
        C=EPS
        GX=0.0
        G=KS
      ENDIF
      UP=1.0/C*(GX*UX+G*UXX+GX)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION U0
      U0=AW(X)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION RAND1
      RAND1=RBL(T)
C
*     FUNCTION RAND3
      RAND3=RBR(T)
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION FITm
      FITm=U
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

