C
C------------------------------------------------------
C
C     Problem:    GREASE
C
C     Date:       17.06.2003
C
C------------------------------------------------------
C                    
*     REAL CONSTANT
      a = 5.9
      p0 = 1.98
      rho0 = 840
      zexp = 0.687
      U = 19.658
C
C------------------------------------------------------
C                                 
*     LININT h
      0.0    5.0
      0.5    1.0
      0.95   1.0
      1.5    1.1
C                                  
*     CONINT h_x
      0.0    -1.8
      0.5     0.0
      0.95    1.0
      1.5     1.0
C
C------------------------------------------------------
C                      
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      z0, eta0, xE, p, z, x
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION p_x             
      eta = eta0*exp((log(eta0) + 9.67)*(-1 + abs(1+p/p0)**zexp)) 
      rho = rho0*(a + 1.34*p)/(a + p)
      p_x = eta*z/(rho*h(x)**3)*xE
C
*     FUNCTION z_x
      rho_p = rho0*a*0.34/(a + p)**2   
      px = eta*z/(rho*h(x)**3)*xE
      z_x = 6*U*(rho_p*px*h(x) + rho*h_x(x)/xE)*xE
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION p_0     
      IF (x.LT.0.000001) THEN
        p_0 = 10
      ELSE
        p_0 = p
      ENDIF    
C
*     FUNCTION z_0
      IF (x.LT.0.000001) THEN
        z_0 = z0 
      ELSE
        z_0 = z
      ENDIF    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION p_fit
      p_fit = p
C
*     FUNCTION z_fit
      z_fit = z
C    
*     FUNCTIOn aux
      rho = rho0*(a + 1.34*p)/(a + p)
      rho_p = rho0*a*0.34/(a + p)**2
      px = eta*z/(rho*h(x)**3)*xE
      aux = h_x(x)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION g
c      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
