C
C------------------------------------------------------
C
C     Problem:    GOLF
C
C     Date:       20.11.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.14156
      m = 0.2
      D = 0.05
      v1_wind = -50
      v2_wind = 10
      v3_wind = 0
      g = 9.81
      wi = pi*0.2
      wwi = pi*0.25
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      mue, nue, x1, x2, x3, v1, v2, v3, vb0, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_p
      x1_p = v1
C
*     FUNCTION x2_p
      x2_p = v2
C
*     FUNCTION x3_p
      x3_p = v3
C
*     FUNCTION v1_p
      norm = sqrt((v1 - v1_wind)**2 + (v2 - v2_wind)**2 +
     /            (v3 - v3_wind)**2)
      Re = norm*D/(nue*1.0E-5)
      IF (Re.LT.9.0E4) THEN
        CD = 0.4
      ELSE
        CD = 0.1
      ENDIF
      v1_p = (0.5*CD*Re*D*pi*mue*0.25E-5*(v1_wind - v1))/m 
C
*     FUNCTION v2_p
      v2_p = (0.5*CD*Re*D*pi*mue*0.25E-5*(v2_wind - v2))/m 
C
*     FUNCTION v3_p
      v3_p = (0.5*CD*Re*D*pi*mue*0.25E-5*(v3_wind - v3) 
     /       - m*g*x3)/m 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 0
C
*     FUNCTION x2_0
      x2_0 = 0
C
*     FUNCTION x3_0
      x3_0 = 0
C
*     FUNCTION v1_0
      v1_0 = vb0*cos(wi)*cos(wwi)
C
*     FUNCTION v2_0
      v2_0 = vb0*cos(wi)*sin(wwi)
C
*     FUNCTION v3_0
      v3_0 = vb0*sin(wi)
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
