C
C------------------------------------------------------
C
C     Problem:    GO2
C
C     Date:       22.11.2002
C
C------------------------------------------------------
C
*     PARAMETER
      n = 5
      n1 = 3
C
C------------------------------------------------------
C
*     INDEX
      k 
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
      ind1 = 1..n1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      x(i), i in ind
      t
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION f1(i), i in ind
      f1(i) = sqrt(i)*x(i)
C
*     FUNCTION f21
      k = n
      f21 = sin(x(k)*sin(x(1)) - x(1) + sin(x(2)))
C
*     FUNCTION f22(i), i in ind1
      f22(i) = sqrt(i+1)*sin(x(i)*sin(x(i+1)) - x(i+1) 
     /         + sin(x(i+2)))
C
*     FUNCTION f23
      f23 = sqrt(k)*sin(x(k-1)*sin(x(k)) - x(k) + sin(x(1)))
C
*     FUNCTION f31
      w = 1 + (x(k)**2 - 2*x(1) + 3*x(2) - cos(x(1)) + 1)**2
      if (w.ne.0) then
        f31 = sqrt(log(w))
      else
        f31 = 0
      endif
C
*     FUNCTION f32(i), i in ind1
      w = 1 + (i+1)*(x(i)**2 - 2*x(i+1) + 3*x(i+2) 
     /     - cos(x(i+1)) + 1)**2
      if (w.ne.0) then
        f32(i) = sqrt(i+1)*sqrt(log(w))
      else
        f32(i) = 0
      endif
C
*     FUNCTION f33
      w = 1 + k*(x(k-1)**2 - 2*x(k) + 3*x(1) - cos(x(k)) + 1)**2
      if (w.ne.0) then
        f33 = sqrt(k)*sqrt(log(w))
      else
        f33 = 0
      endif
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
