C
C------------------------------------------------------
C
C     Problem:    GLUCOSE2
C
C     Date:       22.11.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      gb = 82.0
      ib = 3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      n, gamma, p1, p2, p3, g0, i0, h, g, x, i, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION g_p
      g_p = -(p1 + x)*g + p1*gb
C
*     FUNCTION x_p
      x_p = -p2*x + p3*(i - ib)
C
*     FUNCTION i_p
      if (g.lt.h) then
        i_p = -n*i
      else
        i_p = -n*i + gamma*(g - h)*t
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION g_0
      g_0 = g0
C
*     FUNCTION x_0
      x_0 = 0
C
*     FUNCTION i_0
      i_0 = i0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION g_fit
      g_fit = g
C
*     FUNCTION i_fit
      i_fit = i
C
*     FUNCTION x_fit
      x_fit = x
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C