C
C------------------------------------------------------
C
C     Problem:    GLUCOSE
C
C     Date:       17.11.00
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      rGmax, kG, rFmax, kF, yxs, mum, kaG, kaF, kuD
      G, F, X, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION G_t  
      rG = rGmax*G/(kG + G)
      G_t = -rG*X
C
*     FUNCTION F_t
      rF = rFmax*F/(kF + F)*(rGmax - rG)/rGmax
      F_t = -rF*X
C
*     FUNCTION X_t
      mu = yxs*(rG + rF) - mum
      X_t = mu*X
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION G_0
      G_0 = 15
C
*     FUNCTION F_0
      F_0 = 15
C
*     FUNCTION X_0
      X_0 = 1.5
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION uD
      uD = (1.333 + kuD)*(G + F)
C
*     FUNCTION aD
      aD = kaG*G + kaF*F
C
*     FUNCTION G_fit
      G_fit = G
C
*     FUNCTION F_fit
      F_fit = F
C
*     FUNCTION X_fit
      X_fit = X
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
