C
C------------------------------------------------------
C
C     Problem:    GLOBCO2
C
C     Date:       25.02.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Tam = 5.8
      Tul = 2.0
      Tdm = 1500
      beta = 0.6
      Flb0 = 2.6E16
      Fsb0 = 3.0E16
      Fmb0 = 2.0E16
      Cmt  = 12.011*0.002057
      Corg = 0.001
      epsilon = 12.5
      Ws = 1.370E21
      gamma0 = 2.3937E-29
      r = 0.03077
      Na0 = 6.156E17
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      P1, P2, P3, P4, P5, Cua, Clb, Csb, Cla, Cml, Cmb, Cds, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Cua_t
      Wm = P4*Na0/(Cmt + Corg)
      gamma = gamma0*exp(r*(t+1700))
      Dlu = (1.0/Tul)*(P1/(1.0 - P1)*Cla - Cua)
      Dlb = beta*Flb0/Na0*Cla
      Dsb = 1.0/Na0*Fsb0*(beta*Cla + Clb/P2 - Csb/P3)
      Dml = 1.0/Tam*((1.0 + Corg/Cmt)/P4*epsilon*Cml 
     /                                  - 1.0/(1.0 - P1)*Cla)
      Dmb = Fmb0/Na0*(1.0 + Cmb/P5)*beta*Cml/P4
      Dmd = 1.0/Tdm*((Ws/Wm - 1.0)*Cml - Cds)
      Cua_t = Dlu
C
*     FUNCTION Clb_t
      Clb_t = Dlb
C
*     FUNCTION Csb_t
      Csb_t = Dsb
C
*     FUNCTION Cla_t
      Cla_t = -Dlu - Dsb - Dlb + Dml + gamma
C
*     FUNCTION Cml_t
      Cml_t = -Dml - Dmd - Dmb
C
*     FUNCTION Cmb_t
      Cmb_t = Dmb
C
*     FUNCTION Cds_t
      Cds_t = Dmd
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C      
*     FUNCTION Cua_0
      Cua_0 = 0
C
*     FUNCTION Clb_0
      Clb_0 = 0
C
*     FUNCTION Csb_0
      Csb_0 = 0
C
*     FUNCTION Cla_0
      Cla_0 = 0
C
*     FUNCTION Cml_0
      Cml_0 = 0
C
*     FUNCTION Cmb_0
      Cmb_0 = 0
C
*     FUNCTION Cds_0
      Cds_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Cua_fit
      Cua_fit = Cua
C
*     FUNCTION Clb_fit
      Clb_fit = Clb
C
*     FUNCTION Csb_fit
      Csb_fit = Csb
C
*     FUNCTION Cla_fit
      Cla_fit = Cla
C
*     FUNCTION Cml_fit
      Cml_fit = Cml
C
*     FUNCTION Cmb_fit
      Cmb_fit = Cmb
C
*     FUNCTION Cds_fit
      Cds_fit = Cds
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
