C
C------------------------------------------------------
C
C     Problem:    GLIDER
C
C     Date:       17.01.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      m = 100.0
      c_D0 = 0.034
      k = 0.069662
      S = 14.0
      rho = 1.13
      R = 100.0
      u_Amax = 2.5
      x_A0 = 350.0
      g = 9.80665
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      c_L1, c_L2, t1, t2, x, y, v_x, v_y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_p
      x_p = v_x
C
*     FUNCTION y_p
      y_p = v_y
C
*     FUNCTION v_x_p
      if ((t.le.t2).and.(t.ge.t1)) then
         c_L = c_L1
      else
         c_L = c_L2
      endif
      w = ((x - x_A0)/R)**2
      u_A = u_Amax*exp(-w)*(1 - w)
      v_r = sqrt(v_x**2 + (v_y - u_A)**2)
      L = 0.5*c_L*rho*S*v_r**2
      c_D = c_D0 + k*c_L**2
      D = 0.5*c_D*rho*S*v_r**2
      sin_eta = (v_y - u_A)/v_r
      cos_eta = v_x/v_r
      v_x_p = (-L*sin_eta - D*cos_eta)/m
C
*     FUNCTION v_y_p
      v_y_p = (L*cos_eta - D*sin_eta - m*g)/m
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      if (t.lt.0.00001) then
        x_0 = 0.0
      else
        x_0 = x
      endif
C
*     FUNCTION y_0
      if (t.lt.0.00001) then
        y_0 = 1000.0
      else
        y_0 = y
      endif
C
*     FUNCTION v_x_0
      if (t.lt.0.00001) then
        v_x_0 = 13.2275675
      else
        v_x_0 = v_x
      endif
C
*     FUNCTION v_y_0
      if (t.lt.0.00001) then  
        v_y_0 = -1.28750052
      else
        v_y_0 = v_y
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y_fit
      y_fit = y
C
*     FUNCTION v_x_fit
      v_x_fit = v_x
C
*     FUNCTION v_y_fit
      v_y_fit = v_y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION res
      res = t2 - t1
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




