C
C------------------------------------------------------
C
C     Problem:    GIBBFUJI
C
C     Date:       06.09.2003
C
C------------------------------------------------------
C     
*     SET OF INDICES
      ind = 1..8
C
C------------------------------------------------------
C     
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE 
      yxn, kn_s, yxco2, yxo2, betam_s, ki_s, yxs, ms
      mun, kd, k_s, mco2, mo2, kp     
      x(i), i in ind
      t
C                           
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dx1   
      betam = betam_s*0.0001   
      ki = ki_s*10000
      kn = kn_s*0.0001                
      k = k_s*0.0001
      dx1 = mun*x(3)/(kn+x(3))*x(1)-kd*x(1)
C
*     FUNCTION dx2
      if (x(2).gt.0) then
        dx2 = -k    
      else
        dx2 = 0 
      endif  
C
*     FUNCTION dx3
      if (x(2).gt.0) then
        dx3 = 0.47*k-mun*x(3)/(kn+x(3))*x(1)/yxn   
      else
        dx3 = -mun*x(3)/(kn+x(3))*x(1)/yxn
      endif  
C
*     FUNCTION dx4
      dx4 = mun*x(3)/(kn+x(3))*x(1)
C
*     FUNCTION dx5
      dx5 = mun*x(3)/(kn+x(3))*x(1)/yxco2+mco2*x(1)
C
*     FUNCTION dx6
      dx6 = mun*x(3)/(kn+x(3))*x(1)/yxo2+mo2*x(1)
C
*     FUNCTION dx7
      dx7 = betam/(1+ki*x(3))*x(1)-kp*x(7)
C
*     FUNCTION dx8
      dx8 = -mun*x(3)/(kn+x(3))*x(1)/yxs-ms*x(1)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 0.004641
C
*     FUNCTION x2_0
      u0 = 3.5/1000
      x2_0 = u0 
 C
*     FUNCTION x3_0
      x3_0 = 0 
C
*     FUNCTION x4_0
      x4_0 = 0.004641 
C
*     FUNCTION x5_0
      x5_0 = 0      
C
*     FUNCTION x6_0
      x6_0 = 0
C
*     FUNCTION x7_0
      x7_0 = 0
C
*     FUNCTION x8_0
      x8_0 = 182.55/1000
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION pred1
      pred1 = x(2)
C
*     FUNCTION pred2  
      pred2 = x(4)
C
*     FUNCTION pred3  
      pred3 = x(5)
C
*     FUNCTION pred4  
      pred4 = x(6)
C
*     FUNCTION pred5  
      pred5 = x(7)
C
*     FUNCTION pred6  
      pred6 = x(8)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
