C
C------------------------------------------------------
C
C     Problem:    GEAR
C
C     Date:       01.12.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      X41 = 150
      Y41 = -100
      X71 = 210
      Y71 = 0
      L1  = 150
      L2  = 26.2
      L3  = 51
      L4  = 173
      K1  = 1
      K2  = -1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      X1, X2, X3, X4, X5, X6, PSI2
C
C------------------------------------------------------
C
C   - Fitting criteria:
C   
*     FUNCTION PSI7
      A2   = X1
      A5   = X2
      L5   = X3*L1
      L6   = X4*L1
      L7   = X5*L1
      A7   = X6
      PHI2 = PSI2 - A2
      X23  = L2*COS(PHI2)
      Y23  = L2*SIN(PHI2)
      xx1  = x23 - x41
      yy1  = y23 - y41
      A34  = 2*xx1*L4/(xx1**2 + yy1**2 + L4**2 - L3**2)
      B34  = 2*yy1*L4/(xx1**2 + yy1**2 + L4**2 - L3**2)
      W1   = (B34 + K1*A34*SQRT(ABS(A34**2 + B34**2 - 1)))
     /           /(A34**2 + B34**2)
      W2   = (A34 - K1*B34*SQRT(ABS(A34**2 + B34**2 - 1)))
     /       /(A34**2 + B34**2)
      IF (ABS(W2).LE.1) THEN
         PHI4 = ACOS(W2)
      ELSE
         PHI4 = 0
      ENDIF
      hilf1 = phi4
      hilf2 = 1
      IF (w1.lt.0) THEN
         hilf2 = -1
      ENDIF
      phi4 = hilf1*hilf2
      PHI5 = PHI4 - A5
      X56  = L5*COS(PHI5) + X41
      Y56  = L5*SIN(PHI5) + Y41
      xx2  = x56 - x71
      yy2  = y56 - y71
      A67  = 2*xx2*L7/(xx2**2 + yy2**2 + L7**2 - L6**2)
      B67  = 2*yy2*L7/(xx2**2 + yy2**2 + L7**2 - L6**2)
      W3   = (B67 + K2*A67*SQRT(ABS(A67**2+B67**2 - 1)))
     /            /(A67**2 + B67**2)
      W4   =(A67 - K2*B67*SQRT(ABS(A67**2 + B67**2 - 1)))
     /            /(A67**2 + B67**2)
      IF (ABS(W4).LE.1) THEN
         PHI7 = ACOS(W4)
      ELSE
         PHI7 = 0
      ENDIF
      hilf1 = phi7
      hilf2 = 1
      IF (ABS(w3).lt.0) THEN
          hilf2 = -1
      ENDIF
      phi7 = hilf1*hilf2
      PSI7 = PHI7 + A7
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION G1        
      G1 = (A34**2 + B34**2 - 1)
C
*     FUNCTION G2
      G2 = (A67**2 + B67**2 - 1)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C