C
C------------------------------------------------------
C
C     Problem:    GAS_DIF2
C
C     Date:       29.07.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      eps = 0.39
      V1 = 19450
      V2 = 20050
      A = 78.5
      L = 6
      c1 = 3.25442
      c2 = 18.8154
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D, c, c_x, c_xx, y2, y1, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = U
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_p
      c_p = D*c_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_0
      c_0 = c1
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION y2_p
      y2_p = eps*A*D/V2*c_x
C
*     FUNCTION y1_p
      y1_p = -eps*A*D/V1*c_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION y2_0
      y2_0 = c2 
C
*     FUNCTION y1_0
      y1_0 = c1
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION c_left
      c_left = y2      
C
*     FUNCTION c_right
      c_right = y1      
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c_fit
      c_fit = c
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
