C
C------------------------------------------------------
C
C     Problem:    GAS_CONV
C
C     Date:       29.07.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      A = 55.4
      L = 10
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D, v, c1, c, c_x, c_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = U
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_p
      c_p = D*c_xx - v*c_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_0
      c_0 = c1
C
C------------------------------------------------------
C
C   - Left boundary function:
C
*     FUNCTION c_left
      c_left = 20.9
C
C------------------------------------------------------
C
C   - Right boundary derivative:
C
*     FUNCTION cx_right
      cx_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c_fit
      c_fit = c
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
