C
C------------------------------------------------------
C
C     Problem:    GAS_BUBB
C
C     Date:       20.1.2000
C
C------------------------------------------------------
C
*     PARAMETER
      n = 10
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
C
C------------------------------------------------------
C
*     INDEX
      i
C
C------------------------------------------------------
C
*     REAL CONSTANT
      rho10 = 0.1
      rho0 = 1
      R1ini = 1
      RT = 1E+6
      h = 1/n
      xa(j) = j/n, j in ind
C
C------------------------------------------------------
C
*     CONINT pinf
      0.0  0.0
      0.3  0.02
      100.0 0.02
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D, sigma, rho2, rho2_x, rho2_xx
      rho2x(j), j in ind
      R1, R1p, R0, rho1, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION rho2_t
      R10 = R1 - R0
      R10x = R0 + x*R10
      R0p = R1p*R1**2/R0**2
      u0 = -R1p*R1**2/R10x**2   
      rho2_t = (R0p + x*(R1p-R0p) + u0)/R10*rho2_x
     /         + D/R10**2*(rho2_xx + 2*R10/R10x*rho2_x)          
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION rho2_0
      rho2_0 = rho10
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION rho2x_t(j), j in ind
      R10 = R1 - R0
      R10x = R0 + x*R10
      R0p = R1p*R1**2/R0**2
      u0 = -R1p*R1**2/R10x**2
      rho2x_t(j) = (R0p + x*(R1p-R0p) + u0)/R10*rho2_x
     /        + D/R10**2*(rho2_xx + 2*R10/R10x*rho2_x)          
C
*     FUNCTION R1_t
      R1_t = R1p
C
*     FUNCTION R1p_t
      if ((R1.gt.1E8).and.(R0.gt.1E8)) then
        p01 = rho1*RT - 2*sigma/R1
        R1p_t = (((p01 - pinf(t))/rho0
     /       + 1/2*(R1**2*R1p)**2*(1/R1**4 - 1/R0**4))
     /                          /(2*R1*R1p*(1/R1 - 1/R0))
     /       - 2*R1*R1p**2)/R1**2
      else
        R1p_t = 0
      endif
C
*     FUNCTION R0_t
      R0_t = R0p
C
*     FUNCTION rho1_t
      int1 = 0
      int2 = 0
      int3 = 0
      i=3
  100 continue    
      R10xi = R0 + xa(i)*R10
      R10xi1 = R0 + xa(i-1)*R10
      rho2xi= (rho2x(i+1) - rho2x(i-1))/(2*h)
      rho2xi1= (rho2x(i) - rho2x(i-2))/(2*h)
      rho2xxi = (rho2x(i+1) - 2*rho2x(i) + rho2x(i-1))/h**2
      rho2xxi1 = (rho2x(i) - 2*rho2x(i-1) + rho2x(i-2))/h**2
      rho2xip = (R0p + xa(i)*(R1p-R0p) + u0)/R10*rho2xi
     /               + D/R10**2*(rho2xxi + 2*R10/R10xi*rho2xi)
      rho2xip1 = (R0p + xa(i-1)*(R1p-R0p) + u0)/R10*rho2xi1
     /               + D/R10**2*(rho2xxi1 + 2*R10/R10xi1*rho2xi1)
      int1 = int1 + 0.5*R10*(rho2xip*R10xi**2
     /                            + rho2xip1*R10xi1**2)
      int2 = int2 + 0.5*(R1p-R0p)*(rho2x(i)*R10xi**2
     /                            + rho2x(i-1)*R10xi1**2)
      int3 = int3 + 2*R10*(rho2x(i)*R10xi
     /                               *(R0p+xa(i)*(R1p-R0p))**2 + 
     /       rho2x(i-1)*R10xi1*(R0p+xa(i-1)*(R1p-R0p))**2)
      i=i+1
      if (i.lt.n) then
        goto 100
      endif
      int1=0
      rho1_t = 3/R1**3*(-rho1*R1**2*R1p + h*(int1+int2+int3))
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION rho2x_0(j), j in ind
      rho2x_0(j) = rho10
C
*     FUNCTION R1_0
      R1_0 = R1ini
C
*     FUNCTION R1p_0
      R1p_0 = 0
C
*     FUNCTION R0_0
      R0_0 = 0.1
C
*     FUNCTION rho1_0
      p10 = pinf(0) + 2*sigma/R1ini
      rho1_0 = p10/RT
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION rho2_left
      rho2_left = 0
C
*     FUNCTION rho2_right
      rho2_right = rho1
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(j), j in ind
      fit(j) = rho2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
