C
C------------------------------------------------------
C
C     Problem:    GAS_ABS2
C
C     Date:       21.05.2002
C
C------------------------------------------------------
C
*     PARAMETER
      n = 200
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
C
C------------------------------------------------------
C
*     REAL CONSTANT
      u1 = 12
      u2 = 1
C
C------------------------------------------------------
C
*     INDEX
      k
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b
      x(i), i in ind
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t(i), i in ind
      c = a + b
      k = i 
      if (i.eq.1) then
        x_t(i) = -c*x(1) + b*x(2) + a*u1
      else
        if (i.eq.n) then
          x_t(i) = a*x(i-1) - c*x(k) + b*u2
        else
          x_t(i) = a*x(i-1) - c*x(k) + b*x(k+1)
        endif
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0(i), i in ind
      x_0(i) = -0.0307 + (i-1)/(n-1)*0.0966
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x(1)
C
*     FUNCTION xn_fit
      k = n
      xn_fit = x(k)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C








