C
C------------------------------------------------------
C
C     Problem:    GASLIQ2
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
C      VL1=300
C      VL2=100
C      VL3=600   
      VG1=7
      VG2=21
      VG3=21 
      H=0.84E3
      CG0=0.0086
      FL1=110
      FL2=110 
      R=0.082
      TEMP=293 
      FGR1=2
      FGR2=2  
      FG=16.7
      KLA=0.09   
      CLI=0
      CGI=0
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      VL1, VL2, VL3, CL1, CL2, CL3, CG1, CG2, CG3, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CL1P
      CL1EQUIL=R*TEMP*CG1/H  
      CL2EQUIL=R*TEMP*CG2/H  
      CL3EQUIL=R*TEMP*CG3/H  
      Q1=KLA*(CL1EQUIL-CL2)*VL1   
      Q2=KLA*(CL2EQUIL-CL3)*VL2   
      Q3=KLA*(CL3EQUIL-CL3)*VL3   
      CL1P=(FL2*(CL2-CL1)+Q1)/VL1   
C
*     FUNCTION CL2P
      CL2P=(FL2*(CL1-CL2)+FL1*(CL3-CL2)+Q2)/VL2 
C
*     FUNCTION CL3P
      CL3P=(FL1*(CL2-CL3)+Q3)/VL3
C
*     FUNCTION CG1P
      CG1P=(FGR1*(CG2-CG1)-Q1)/VG1  
C
*     FUNCTION CG2P
      CG2P=(FG*CG0+FGR1*(CG1-CG2)+FGR2*CG3-(FGR2+FG)*CG2-Q2)/VG2 
C
*     FUNCTION CG3P
      CG3P= ((FGR2+FG)*(CG2-CG3)-Q3)/VG3 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CL1_0
      CL1_0=CLI
C
*     FUNCTION CL2_0
      CL2_0=CLI
C
*     FUNCTION CL3_0
      CL3_0=CLI
C
*     FUNCTION CG1_0
      CG1_0=CGI
C
*     FUNCTION CG2_0
      CG2_0=CGI
C
*     FUNCTION CG3_0
      CG3_0=CGI
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CL1_FIT
      CL1_FIT=CL1
C
*     FUNCTION CL2_FIT
      CL2_FIT=CL2
C
*     FUNCTION CL3_FIT
      CL3_FIT=CL3
C
*     FUNCTION CG1_FIT
      CG1_FIT=CG1
C
*     FUNCTION CG2_FIT
      CG2_FIT=CG2
C
*     FUNCTION CG3_FIT
      CG3_FIT=CG3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
