C
C------------------------------------------------------
C
C     Problem:    GAMMAS
C
C     Date:       25.03.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      sc = 0.001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      p1, p2, p3, p4, p5, p6, p7, i
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION f
      b1 = p2 - p6**2
      b2 = p2 + p7**2
      IF (i.LT.b1) THEN
        w = (p6*(2*i - 2*p2 + p6**2)/p3)**2
      ELSE
        IF (i.LE.b2) THEN
          w = ((i - p2)/p3)**2
        ELSE
          w = (p7*(2*p2 - 2*i + p7**2)/p3)**2
        ENDIF
      ENDIF
      f = p4 + p5*(i - p2) + p1*EXP(-0.5*w)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


