C
C------------------------------------------------------
C
C     Problem:    FUP_OSCI
C
C     Date:       21.05.2002
C
C------------------------------------------------------
C
*     PARAMETER
      n = 20
      n1 = 18
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
      ind1 = 1..n1
C
C------------------------------------------------------
C
*     REAL CONSTANT
      m = 1   
      pi = 3.1415926535
C
C------------------------------------------------------
C
*     INDEX
      k
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b
      z(i), i in ind
      x(i), i in ind
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION z1_t
      z1_t = a*(-2*x(1) + x(2))*(1 + b*x(2))/m
C
*     FUNCTION z_t(i), i in ind1
      k = i+1
      z_t(i) = a*(x(k-1)-2*x(k) + x(k+1))*(1 + b*(x(k+1) - x(k-1)))/m
C
*     FUNCTION zn_t
      k = n
      zn_t = a*(x(k-1)-2*x(k))*(1 - b*x(k-1))/m
C
*     FUNCTION x_t(i), i in ind
      x_t(i) = z(i)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION z_0(i), i in ind
      z_0(i) = 0
C
*     FUNCTION x_0(i), i in ind
      k = i
      x_0(i) = sqrt(1/(n-1))*sin(pi*k/(n-1))
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION xn_fit(i), i in ind
      xn_fit(i) = x(i)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


