C
C------------------------------------------------------
C
C     Problem:    FUNGI
C
C     Date:       30.7.1999
C
C------------------------------------------------------
C 
*     SET OF INDICES
      ind = 1..11
C     
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      alpha(i), i in ind
      beta, gamma, y, L, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y_t
      y_t = beta*y*(1 - y/(gamma*L))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y_0 
      if (L.lt.5) then
        y_0 = alpha(1)
      else
      if (L.lt.20) then
        y_0 = alpha(2)
      else
      if (L.lt.100) then
        y_0 = alpha(3)
      else
      if (L.lt.200) then
        y_0 = alpha(4)
      else
      if (L.lt.400) then
        y_0 = alpha(5)
      else
      if (L.lt.800) then
        y_0 = alpha(6)
      else
      if (L.lt.1600) then
        y_0 = alpha(7)
      else
      if (L.lt.3000) then
        y_0 = alpha(8)
      else
      if (L.lt.5000) then
        y_0 = alpha(9)
      else
      if (L.lt.8000) then
        y_0 = alpha(10)
      else
        y_0 = alpha(11)
      endif      
      endif      
      endif      
      endif      
      endif      
      endif      
      endif      
      endif      
      endif      
      endif      
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


