C
C------------------------------------------------------
C
C     Problem:    FRONT
C
C     Date:       4.07.1996
C
C------------------------------------------------------
C       
*     SET OF INDICES
      IND = 1..4
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L = 2
C
C------------------------------------------------------
C    
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      alpha, beta, T, Y, T_x, Y_x, T_xx, Y_xx, x, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T_t 
      R = beta**2/(2*L)*Y*exp(-beta*(1-T)/(1 - alpha*(1-T)))
      T_t = T_xx + R
C
*     FUNCTION Y_t
      Y_t = Y_xx/L - R
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T_0
      if (x.lt.0) then
        T_0 = exp(x)
      else
        T_0 = 1
      endif  
C
*     FUNCTION Y_0
      if (x.lt.0) then
        Y_0 = 1 - exp(L*x)
      else  
        Y_0 = 0
      endif  
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION T_left
      T_left = 0
C
*     FUNCTION Y_left
      Y_left = 1
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION T_x_right
      T_x_right = 0
C
*     FUNCTION Y_x_right
      Y_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind
      fit(i) = T
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

