C
C------------------------------------------------------
C
C     Problem:    FRACTAK
C
C     Date:       23.12.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L = 1.0E+7
      L1 = 3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1p, k1m, r0, k2p, k2m, y10, y20
      y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_p  
      y1_p = k1p*(r0-y1-y2)*(L1-y1) - k1m*y1
C
*     FUNCTION y2_p
      y2_p = k2p*(r0-y1-y2)*(L-y2) - k2m*y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = y10
C
*     FUNCTION y2_0
      y2_0 = y20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = r0-y1-y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


