C
C------------------------------------------------------
C
C     Problem:    FOREST
C
C     Date:       21.2.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      f = 0.2
      k = 10
      d = 0.01
      q = 10
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      r, b, p, s, tlag, x, y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      if (t.ge.tlag) then
        u = q
      else
        u = 0
      endif
      l = b*y*(1 - y/k)
      a = r*y*p*(1 - u) - l - s*x
      if (a.lt.0) then
        a = 0
        l = r*y*p*(1 - u) - s*x
        if (l.lt.0) then
          l = 0
        endif
      endif
      x_t = a - d*x
C
*     FUNCTION y_t
      y_t = l - f*y
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 1
C
*     FUNCTION y_0
      y_0 = 0.2
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
