C
C------------------------------------------------------
C
C     Problem:    FOLDING5
C
C     Date:       9.9.1993
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k12, k21, k23, c1, c2, Ucc, Utc, Uct, Utt, N, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION UccP
      UccP = -(2*k21 + k23)*Ucc + k12*(Utc + Uct) + (0.66 - k23)*N
C
*     FUNCTION UtcP
      UtcP = k12*(Utt - Utc) + k21*(Ucc - Utc)
C
*     FUNCTION UctP
      UctP = k12*(Utt - Uct) + k21*(Ucc - Uct)
C
*     FUNCTION UttP
      UttP = -2*k12*Utt + k21*(Utc + Uct)
C
*     FUNCTION NP
      NP = -(0.66-k23)*N + k23*Ucc
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Ucc0
      Ucc0 = 0
C
*     FUNCTION Utc0
      Utc0 = 0
C
*     FUNCTION Uct0
      Uct0 = 0
C
*     Function Utt0
      Utt0 = 0
C
*     FUNCTION N0
      N0 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION UccFIT
      UccFIT = c1*Ucc
C
*     FUNCTION UtcFIT
      UtcFIT = c2*Utc
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

