C
C------------------------------------------------------
C
C     Problem:    FOLDING3
C
C     Date:       8.11.1993
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, c1, c2, N, Ucc, Uct, Ict, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION NP
      NP = k1*Ucc
C
*     FUNCTION UccP
      UccP = -(k1 + k3)*Ucc
C
*     FUNCTION UctP
      UctP = -k2*Uct + k3*Ucc
C
*     FUNCTION IctP
      IctP = k2*Uct
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION N0
      N0 = 0
C
*     FUNCTION Ucc0
      Ucc0 = 1
C
*     FUNCTION Uct0
      Uct0 = 0
C
*     Function Ict0
      Ict0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     Function IctFIT
      IctFIT = c1*(Ucc + Uct) + c2*(Ict - k3/(k1 + k3))
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
