C
C----------------------------------------------------------------
C
C     Problem:    FOLDING1
C
C     Date:       30.10.1993
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k12, k21, k32, k23, k43, c1, c2, Ucc, Uct, Utt, N, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C

*     FUNCTION UccP
      UccP=-k23*Ucc + k43*N
C
*     FUNCTION UctP
      UctP=-k21*Uct + k32*Ucc + k12*Utt
C
*     FUNCTION UttP
      UttP= -k12*Utt + k21*Uct
C
*     FUNCTION NP
      NP= -k43*N 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Ucc0
      Ucc0=0.0
C
*     FUNCTION Uct0
      Uct0=0.0
C
*     Function Utt0
      Utt0=0.0
C
*     FUNCTION N0
      N0=1.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION UccFIT
      UccFIT=c1*Ucc + c2*Uct
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
