C
C------------------------------------------------------
C
C     Problem:    FLUORES
C
C     Date:       27.07.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      rk1  = 3000.0 
      rkm1 =  150.0 
      rk2  = 1500.0 
      rkm2 =   30.0 
      rkH  = 1300.0 
      rkmH = 1300.0
      rkE  =  100.0 
      rkmE =  100.0 
      rkmP =    0.0
      rN   =  4.0
      PQtot=  6.0         
      F0   =  717.0 
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind39 = 1..39
      ind8 = 1..8
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      x(i), i in ind8
      y(i), i in ind39
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION ydot1
      r0kL0 = x(1)
      r0kL1 = r0kL0
      r0kL2 = x(2)
      r0kL3 = r0kL2
      fcl   = x(3)
      fop   = x(4)
      C     = x(5)
      rkS2  = x(6)
      rkS3  = x(7)
      rkP   = x(8)
C
      BB = y(2)+y(4)+y(6)+y(8)+y(10)+y(11)+y(14)+y(16)+y(18)+
     &     y(19)+ y(23)+y(25)+y(27)+y(29)+y(31)+y(32)+y(35)+
     &     y(39)
C
      C1   = 1.0d0 + C
      C0   = C1/(1.0d0+C*(1.0d0 - BB))
      rkL0 = r0kL0*C0
      rkL1 = r0kL1*C0
      rkL2 = r0kL2*C0
      rkL3 = r0kL3*C0
      ydot1 = -rkL1*y(1)+rkE*y(20)*y(17)-rkmE*y(1)*y(21)
C
*     FUNCTION ydot2
      ydot2 = rkL1*y(1)-rk1*y(2)+rkm1*y(3) 
C
*     FUNCTION ydot3
      ydot3 = rk1*y(2)-rkm1*y(3)-rkL2*y(3)+rk1*y(19)-rkm1*y(3)
C
*     FUNCTION ydot4
      ydot4 = rkL2*y(3)-rk2*y(4)+rkm2*y(5) 
C
*     FUNCTION ydot5
      ydot5 = rk2*y(4)-rkm2*y(5)-rkL3*y(5)-rkH*y(5)+rkmH*y(7)
C
*     FUNCTION ydot6
      ydot6 = rkL3*y(5)-rkH*y(6)+rkmH*y(8) 
C
*     FUNCTION ydot7
      ydot7 = rkH*y(5)-rkmH*y(7)-rkL3*y(7)-
     /                rkE*y(7)*y(20)+rkmE*y(9)*y(21) 
C
*     FUNCTION ydot8
      ydot8 =  rkH*y(6)-rkmH*y(8)+rkL3*y(7)-
     /                rkE*y(8)*y(20)+ rkmE*y(21)*y(11) 
C
*     FUNCTION ydot9
      ydot9 = rkE*y(7)*y(20)-rkmE*y(9)*y(21)-rkL3*y(9)
C
*     FUNCTION ydot10
      ydot10 = rkL3*y(9)-rk1*y(10)+rkm1*y(12)
C
*     FUNCTION ydot11
      ydot11 = rkE*y(8)*y(20)-rkmE*y(21)*y(11)-rk1*y(11)+rkm1*y(13)
C
*     FUNCTION ydot12
      ydot12 = rk1*y(10)-rkm1*y(12)-rkS3*y(12) 
C
*     FUNCTION ydot13
      ydot13 = rkS3*y(12)+rk1*y(11)-rkm1*y(13)-rkL0*y(13) 
C
*     FUNCTION ydot14
      ydot14 = rkL0*y(13)-rk2*y(14)+rkm2*y(15) 
C
*     FUNCTION ydot15
      ydot15 = rk2*y(14)-rkm2*y(15)-rkL1*y(15)-
     /                rkH*y(15)+rkmH*y(17) 
C
*     FUNCTION ydot16
      ydot16 = rkL1*y(15)-rkH*y(16)+rkmH*y(18) 
C
*     FUNCTION ydot17
      ydot17 = rkH*y(15)-rkmH*y(17)-rkL1*y(17)-
     /                rkE*y(20)*y(17)+ rkmE*y(1)*y(21) 
C
*     FUNCTION ydot18
      ydot18 = rkH*y(16)-rkmH*y(18)+rkL1*y(17)-
     /                rkE*y(20)*y(18)+rkmE*y(21)*y(19) 
C
*     FUNCTION ydot19
      ydot19 = rkE*y(20)*y(18)-rkmE*y(21)*y(19)-
     /                rk1*y(19)+rkm1*y(3)
C
*     FUNCTION ydot20
      ydot20 = -rkE*y(7)*y(20)+rkmE*y(9)*y(21)-rkE*y(8)*y(20)+
     /               rkmE*y(21)*y(11)- rkE*y(20)*y(17)+rkmE*y(1)*y(21)-
     /               rkE*y(20)*y(18)+rkmE*y(21)*y(19)+rkP*y(21)-rkmP*y(20)
     /               -rkE*y(37)*y(20)+rkmE*y(22)*y(21)-rkE*y(38)*y(20)+
     /               rkmE*y(22)*y(21)-
     /               rkE*y(28)*y(20)+rkmE*y(30)*y(21)-             
     /               rkE*y(29)*y(20)+rkmE*y(32)*y(21)-rkE*y(39)*y(20)+
     /               rkmE*y(23)*y(21)+rkP*y(21)-rkmP*y(20) 
C
*     FUNCTION ydot21
      ydot21 = rkE*y(7)*y(20)-rkmE*y(9)*y(21)+rkE*y(8)*y(20)-
     /              rkmE*y(21)*y(11)+ rkE*y(20)*y(17)-rkmE*y(1)*y(21)+
     /              rkE*y(20)*y(18)-rkmE*y(21)*y(19)- rkP*y(21)+rkmP*y(20)+
     /              rkE*y(28)*y(20)-rkmE*y(30)*y(21)+rkE*y(29)*y(20)-
     /              rkmE*y(32)*y(21)+rkE*y(37)*y(20)-rkmE*y(22)*y(21)+
     /              rkE*y(38)*y(20)-rkmE*y(22)*y(21)+rkE*y(39)*y(20)-
     /              rkmE*y(23)*y(21)-rkP*y(21)+rkmP*y(20)
C
*     FUNCTION ydot22
      ydot22 = -rkL0*y(22)+rkE*y(37)*y(20)-rkmE*y(22)*y(21)+    
     /              rkE*y(38)*y(20)-rkmE*y(22)*y(21)
C
*     FUNCTION ydot23
      ydot23 = rkL0*y(22)-rk1*y(23)+rkm1*y(24)+rkE*y(39)*y(20)-
     /              rkmE*y(23)*y(21)
C
*     FUNCTION ydot24
      ydot24 = rk1*y(23)-rkm1*y(24)-rkL1*y(24)
C
*     FUNCTION ydot25
      ydot25 = rkL1*y(24)-rk2*y(25)+rkm2*y(26)
C
*     FUNCTION ydot26
      ydot26 = rk2*y(25)-rkm2*y(26)-rkL2*y(26)-rkH*y(26)+rkmH*y(28)
C
*     FUNCTION ydot27
      ydot27 = rkL2*y(26)-rkH*y(27)+rkmH*y(29)
C
*     FUNCTION ydot28
      ydot28 = rkH*y(26)-rkmH*y(28)-rkL2*y(28)-rkE*y(28)*y(20)+
     /         rkmE*y(30)*y(21)
C
*     FUNCTION ydot29
      ydot29 = rkH*y(27)-rkmH*y(29)+rkL2*y(28)-rkE*y(29)*y(20)+
     /         rkmE*y(32)*y(21)
C
*     FUNCTION ydot30
      ydot30 = rkE*y(28)*y(20)-rkmE*y(30)*y(21)-rkL2*y(30)
C
*     FUNCTION ydot31
      ydot31 = rkL2*y(30)-rk1*y(31)+rkm1*y(33)
C
*     FUNCTION ydot32
      ydot32 = rkE*y(29)*y(20)-rkmE*y(32)*y(21)-
     /             rk1*y(32)+rkm1*y(34)
C
*     FUNCTION ydot33
      ydot33 = rk1*y(31)-rkm1*y(33)-rkS2*y(33)
C
*     FUNCTION ydot34
      ydot34 = rkS2*y(33)+rk1*y(32)-rkm1*y(34)-rkL3*y(34)
C
*     FUNCTION ydot35
      ydot35 = rkL3*y(34)-rk2*y(35)+rkm2*y(36)
C
*     FUNCTION ydot36
      ydot36 = rk2*y(35)-rkm2*y(36)-rkH*y(36)+rkmH*y(37)
C
*     FUNCTION ydot37
      ydot37 = rkH*y(36)-rkmH*y(37)-rkS3*y(37)-
     /                    rkE*y(37)*y(20)+rkmE*y(22)*y(21)
C
*     FUNCTION ydot38
      ydot38 = rkS3*y(37)-rkL0*y(38)-
     /              rkE*y(38)*y(20)+rkmE*y(22)*y(21)
C
*     FUNCTION ydot39
      ydot39 = rkL0*y(38)-rkE*y(39)*y(20)+rkmE*y(23)*y(21)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y01
      y01  = 0.45
C
*     FUNCTION y02
      y02  = 0
C
*     FUNCTION y03
      y03  = 0
C
*     FUNCTION y04
      y04  = 0
C
*     FUNCTION y05
      y05  = 0
C
*     FUNCTION y06
      y06  = 0
C
*     FUNCTION y07
      y07  = 0
C
*     FUNCTION y08
      y08  = 0
C
*     FUNCTION y09
      y09  = 0
C
*     FUNCTION y010
      y010 = 0
C
*     FUNCTION y011
      y011 = 0
C
*     FUNCTION y012
      y012 = 0 
C
*     FUNCTION y013
      y013 = 0.1
C
*     FUNCTION y014
      y014 = 0
C
*     FUNCTION y015
      y015 = 0
C
*     FUNCTION y016
      y016 = 0
C
*     FUNCTION y017
      y017 = 0 
C
*     FUNCTION y018
      y018 = 0 
C
*     FUNCTION y019
      y019 = 0 
C
*     FUNCTION y020
      y020 = 6 
C
*     FUNCTION y021
      y021 = 0 
C
*     FUNCTION y022
      y022 = 0.1
C
*     FUNCTION y023
      y023 = 0
C
*     FUNCTION y024
      y024 = 0.35
C
*     FUNCTION y025
      y025 = 0
C
*     FUNCTION y026
      y026 = 0
C
*     FUNCTION y027
      y027 = 0
C
*     FUNCTION y028
      y028 = 0
C
*     FUNCTION y029
      y029 = 0 
C
*     FUNCTION y030
      y030 = 0
C
*     FUNCTION y031
      y031 = 0
C
*     FUNCTION y032
      y032 = 0
C
*     FUNCTION y033
      y033 = 0
C
*     FUNCTION y034
      y034 = 0
C
*     FUNCTION y035
      y035 = 0
C
*     FUNCTION y036
      y036 = 0
C
*     FUNCTION y037 
      y036 = 0
C
*     FUNCTION y038
      y038 = 0
C
*     FUNCTION y039
      y039 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION F1
      r0kL0 = x(1)
      r0kL1 = r0kL0
      r0kL2 = x(2)
      r0kL3 = r0kL2
      fcl   = x(3)
      fop   = x(4)
      C     = x(5)
      rkS2  = x(6)
      rkS3  = x(7)
      rkP   = x(8)
      BB    = y(2)+y(4)+y(6)+y(8)+y(10)+y(11)+y(14)+y(16)+y(18)+
     /          y(19)+ y(23)+y(25)+y(27)+y(29)+y(31)+y(32)+y(35)+y(39)      
      V0    = BB/(1 + C*(1 - BB))
      CK    = fcl / ((1.0d0 - fcl) * PQtot)
      OK    = fop / ((1.0d0 - fop) * PQtot)
      rN0   =(rN+1.0)*(1.0+CK*PQtot)/(1.0+OK*PQtot)-1.0
      TK    = BB * (CK - OK) + OK
      V     = (V0 * rN0 * (1 + OK*PQtot) + OK*PQtot -
     /              TK * y(20)) / (rN * (1 + TK * y(20)))
      F1    = F0*(V*rN + 1.0)     
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
C



