C------------------------------------------------------
C
C     Problem:   FLUOR
C
C     Date:      02.07.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k1 = 3500
      k_1 = 175
      k2 = 1750
      k_2 = 1750
C
C------------------------------------------------------
C
*     VARIABLE
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k3, k5, C, alpha, beta, kL, S, 
     /             y1, y2, y3, y4, y5, y6, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      k_3 = k3
      k4 = k3
      k_4 = k3
      C6 = C - y6
      r = kL/(1 - alpha - beta + alpha*beta*(y1 + y3 + y5))
      y1_t = -(r + k3*C6)*y1 + k_3*y5*y6 
C
*     FUNCTION y2_t
      w = 1 - (y1 + y2 + y3 + y4 + y5)
      y2_t = r*y1 - (k1 + k4*C6)*y2 + k_1*y3 + k_4*y6*w
C
*     FUNCTION y3_t
      y3_t = k1*y2 - (r + k_1)*y3
C
*     FUNCTION y4_t
      y4_t = r*y3 - k2*y4 + k_2*y5
C
*     FUNCTION y5_t
      y5_t = k3*C6*y1 + k2*y4 - (r + k_2 + k_3*y6)*y5 
C
*     FUNCTION y6_t
      y6_t = -k_3*y5*y6 - k_4*w*y6 + C6*(k3*y1 + k4*y2 + k5)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 0.75
C
*     FUNCTION y2_0
      y2_0 = 0.0125
C
*     FUNCTION y3_0
      y3_0 = 0.2375
C
*     FUNCTION y4_0
      y4_0 = 0.0
C
*     FUNCTION y5_0
      y5_0 = 0.0
C
*     FUNCTION y6_0
      y6_0 = C
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION F
      r = kL/(1 - alpha - beta + alpha*beta*(y1 + y3 + y5))
      F = S*(1 - alpha*(y1 + y3 + y5))*r
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
