C
C------------------------------------------------------
C
C     Problem:    FLUID_CL
C
C     Date:       14.12.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      eps = 1.0E-10
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, S0, T, S, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION T_t
      T_t = S
C
*     FUNCTION S_t
      Tb = T - 20
      if (Tb.lt.eps) then
        Tb = eps
      endif
      S_t = a*Tb**1.4
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION T_0
      T_0 = 200
C
*     FUNCTION S_0
      S_0 = S0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION T_fit
      T_fit = T
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION boundary
      boundary = T - 40 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

