C  
C------------------------------------------------------
C
C     Problem:    FLOW_PMD
C  
C     Date:       17.09.2001
C  
C------------------------------------------------------
C  
*     SET OF INDICES
      ind = 1..8
C  
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C  
*     VARIABLE
      a, u, u_x, u_xx, f, f_x, x, t
C  
C------------------------------------------------------
C  
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C  
*     FUNCTION flux
      flux = u*(a - u)*u_x
C  
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION u_t
      u_t = f_x
C
C------------------------------------------------------
C  
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C  
*     FUNCTION u_0
      if (x.le.-1) then
        u_0 = 0
      else
      if (x.le.0) then
        u_0 = a*(x + 1)
      else
      if (x.le.0.5) then
        u_0 = a*(1 - 0.7*x)
      else
      if (x.le.1) then
        u_0 = a*(0.7*x + 0.3)
      else
        u_0 = a
      endif
      endif
      endif
      endif
C  
C------------------------------------------------------
C  
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u_left
      u_left = 0
C
*     FUNCTION u_right
      u_right = a
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in ind
      fit(i) = u
C  
C------------------------------------------------------
C  
C   - Constraints (if exist):
C  
C  *     FUNCTION g1
C      g1 = ...
C  
C------------------------------------------------------
C  
*     END
C  
C------------------------------------------------------
C   