C
C------------------------------------------------------
C
C     Problem:    FLOWDIFF
C
C     Date:       01.12.2003
C
C------------------------------------------------------
C
*     REAL CONSTANT
      p = 0
      u0 = 0.1
      v0 = 0
      gamma = 10
      beta_v = 2
      r = 0.5          
      Peu = 0.001
      Bu = 0.1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (One
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.)
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Pev, Bv, u, v, u_z, v_z, u_zz, v_zz, u1, v1, z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION u_t             
      f = (1 + u)*exp(gamma*v/(1+v))  
      u_t = -u_z + u_zz/Peu - Bu*f
C
*     FUNCTION v_t             
      v_t = -v_z + v_zz/Pev + Bv*f + beta_v*(p - v)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION u_0
      u_0 = u0
C
*     FUNCTION v_0
      v_0 = v0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION equ1
      equ1 = u - u1
C
*     FUNCTION equ2
      equ2 = v - v1
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION u1_0
      u1_0 = u0
C
*     FUNCTION v1_0
      v1_0 = v0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_left
c      u_left = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION u_z_left
      u_z_left = Peu*((1 - r)*u0 + r*u1 - u)
C
*     FUNCTION v_z_left
      v_z_left = Pev*((1 - r)*v0 + r*v1 - v)
C
*     FUNCTION u_z_right
      u_z_right = u0
C
*     FUNCTION v_z_right
      v_z_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION v_fit
      v_fit = v1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
