C
C------------------------------------------------------
C
C     Problem:    FLAT_MEM
C
C     Date:       14.01.2003
C
C------------------------------------------------------
C
*     REAL CONSTANT
      alpha = 5.6672E-5
      beta = 2920.754
      gamma = 0.165915
      Lp = 2.0218E-11
      P = 690000
      a = 6072
      C0 = 6.44E-3       
      scale_tau = 0.001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables identifying solution of coupled
C        differential algebraic equations, e.g. implicit
C        boundary conditions (w)
C     7. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDAE.
C     8. spatial variable (x)
C     9. time variable (t)
C
*     VARIABLE
      Rr, C, C_y, C_yy, Cb, Cm, y, tau
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION C_tau
      Pew = beta*(1 - alpha*Cm)
      C_tau = (Pew*C_y + C_yy)*scale_tau
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION C_0
      C_0 = C0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION Cb_tau
      Pew = beta*(1 - alpha*Cm)
      Cb_tau = Pew*gamma*(1 - Cm*(1 - Rr))*scale_tau
C
*     FUNCTION equ
      equ = Cm - C
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION Cb_0
      Cb_0 = C0
C
*     FUNCTION Cm_0
      Cm_0 = C0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION C_right
      C_right = Cb
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION C_y_left                  
      Pew = beta*(1 - alpha*Cm)
      C_y_left = -Pew*Rr*C
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION Cp
      Cp = C*(1 - Rr)
C
*     FUNCTION Vw
      Vw = Lp*(P - a*C*C0*Rr)
C
*     FUNCTION Cm_plot
      Cm_plot = Cm
C
*     FUNCTION Cb_plot
      Cb_plot = Cb
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
