C
C------------------------------------------------------
C
C     Problem:    FLAME
C
C     Date:       4.07.1996
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      T0 = 0.2
      Tf = 1.2 
      rho0 = 1 
      phi = 4
C
C------------------------------------------------------
C    
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      A, C, T, rho, T_x, rho_x, T_xx, rho_xx, x, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T_t 
      w = rho*A*1.0E+6*exp(-phi/T)
      T_t = T_xx + w
C
*     FUNCTION rho_t
      rho_t = rho_xx - w
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T_0
      T_0 = T0
C
*     FUNCTION rho_0
      rho_0 = rho0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION T_right
      T1 = T0 + C*1000*time
      if (time.le.0.0002) then
        T_right = T1
      else
        T_right = Tf
      endif
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C
*     FUNCTION T_x_left
      T_x_left = 0
C
*     FUNCTION rho_x_left
      rho_x_left = 0
C
*     FUNCTION rho_x_right
      rho_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit_T6
      fit_T6 = T
C
*     FUNCTION fit_rho6
      fit_rho6 = rho
C
*     FUNCTION fit_T7
      fit_T7 = T
C
*     FUNCTION fit_rho7
      fit_rho7 = rho
C
*     FUNCTION fit_T8
      fit_T8 = T
C
*     FUNCTION fit_rho8
      fit_rho8 = rho
C
*     FUNCTION fit_T9
      fit_T9 = T
C
*     FUNCTION fit_rho9
      fit_rho9 = rho
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
