C
C------------------------------------------------------
C
C     Problem:    FIX_BED
C
C     Date:       14.10.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      eps = 0.5
      rho = 1
      rhocp = 1200
      cp = 0.6
      MA = 16
      Uw = 0.005
      R1 = 0.012
      Tc = 400
      dhR = -188000
      SR = 0.5
      ER = 4500
      Tb = 620
      Gz = 2
      wA0 = 0.143
      T0 = 310
C
C------------------------------------------------------
C
*     LININT wAzul
      0.0      0.1
      1000.0   0.15
      2000.0   0.15
      3000.0   0.3
      4000.0   0.8
      5000.0   1.3
      6000.0   0.75 
      7000.0   0.5
      8000.0   0.1
      9000.0   0.07
      10000.0  0.05
C
*     LININT Tzul
      0.0      1000.0
      1000.0   850.0
      2000.0   770.0
      3000.0   880.0
      4000.0   700.0
      5000.0   695.0
      6000.0   675.0
      7000.0   570.0
      8000.0   465.0
      9000.0   460.0
      10000.0  455.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Deff, lambdaeff, wA, T, wA_z, T_z, wA_zz, T_zz, z, time
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION wA_t
      rA = wA*rho/MA*SR*exp(ER*(1/Tb - 1/T))
      wA_t = 1/(eps*rho)*(-Gz*wA_z + Deff*wA_zz - rA)
C
*     FUNCTION T_t
      T_t = 1/rhocp*(-Gz*cp*T_z + lambdaeff*T_zz - dhR*rA/MA 
     /                + 2*Uw/R1*(Tc - T))
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION wA_0
      wA_0 = wA0 
C
*     FUNCTION T_0
      T_0 = T0 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_right
c      u_right = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION wA_z_left
      wA_z_left = (wA - wAzul(t))*Gz/Deff
C
*     FUNCTION T_z_left
      T_z_left = (T - Tzul(t))*Gz*cp/lambdaeff
C
*     FUNCTION wA_z_right
      wA_z_right = 0
C
*     FUNCTION T_z_right
      T_z_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      fit = T
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
