C
C------------------------------------------------------
C
C     Problem:    FIXBED
C
C     Date:       28.09.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      eps = 0.5 
      rho = 1
      MA = 16
      SR = 0.5
      ER = 4500
      Tb = 620
      cp = 0.6
      lambdaeff = 25
      UW = 0.005
      R1 = 0.012
      rhocp = 1200
      Tc = 400
      dhR = -188000 
      wA0 = 0
      Gz = 1
      T0 = 310
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Deff, wAzul, Tzul
      wA, T, wA_z, T_z, wA_zz, T_zz, z, time
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION wA_t
      rA = wA*rho/MA*SR*exp(ER*(1/Tb - 1/T))
      wA_t = (-Gz*wA_z + Deff*wA_zz - rA)/(eps*rho)
C
*     FUNCTION T_t
      T_t = (-Gz*cp*T_z + lambdaeff*T_zz - dhR*rA/MA 
     /       + 2*UW/R1*(Tc - T))/rhocp
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION wA_0
      wA_0 = wA0
C
*     FUNCTION T_0
      T_0 = T0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
C*     FUNCTION wA_left
C      wA_left = 
C
C*     FUNCTION u_right
C      u_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
*     FUNCTION wA_z_left
      wA_z_left = (wA - wAzul)*Gz/Deff
C
*     FUNCTION T_z_left
      T_z_left = (T - Tzul)*Gz*cp/lambdaeff
C
*     FUNCTION wA_z_right
      wA_z_right = 0
C
*     FUNCTION T_z_right
      T_z_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION T_fit
      T_fit = T
C
*     FUNCTION wA_fit1
      wA_fit1 = wA
C
*     FUNCTION wA_fit2
      wA_fit2 = wA
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




