C
C------------------------------------------------------
C
C     Problem:    FISH_POP
C
C     Date:       23.6.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      T1 = 4.34
      T2 = 3.57
      T3 = 2.65
      C  = 0.001
      H  = 0.8
C
C------------------------------------------------------
C
*     SPLINE U1
      0.00  0.136200E-01 
      1.00  0.136337E-01 
      2.00  0.139274E-01 
      3.00  0.139543E-01 
      4.00  0.148276E-01 
      5.00  0.753290E-02 
      6.00  0.154921E-01 
      7.00  0.352592E-01 
      8.00  0.402026E-01 
      9.00  0.469002E-01 
      10.00 0.472333E-01 
      11.00 0.593560E-01 
      12.00 0.570552E-01 
      13.00 0.271763E-01 
      14.00 0.319753E-01 
      15.00 0.326080E-01 
      16.00 0.457362E-01 
      17.00 0.409167E-01 
      18.00 0.567907E-01 
      19.00 0.323478E-01 
      20.00 0.355617E-01 
      21.00 0.172763E-01 
      22.00 0.844497E-02 
      23.00 0.558312E-02 
      24.00 0.320358E-02 
      25.00 0.766114E-02 
      26.00 0.586375E-02 
      27.00 0.778354E-02 
      28.00 0.882179E-02 
      29.00 0.203517E-01 
      30.00 0.157395E-01 
      31.00 0.702175E-02 
      32.00 0.796240E-02 
      33.00 0.141298E-01 
      34.00 0.329968E-01 
      35.00 0.234825E-01 
      36.00 0.272168E-01 
      37.00 0.167997E-01 
      38.00 0.167750E-01 
      39.00 0.135154E-01
      40.00 0.980080E-02 
      41.00 0.219089E-01 
      42.00 0.219640E-01 
      43.00 0.154985E-01 
      44.00 0.180180E-01 
      45.00 0.249215E-01 
      46.00 0.262229E-01 
      47.00 0.305264E-01 
      48.00 0.386888E-01 
      49.00 0.260327E-01 
      50.00 0.324219E-01 
      51.00 0.306995E-01 
      52.00 0.209675E-01 
      53.00 0.933099E-02 
      54.00 0.176070E-01 
      55.00 0.110687E-01 
C
*     SPLINE U2
       0.00  0.512686E-01 
       1.00  0.494636E-01 
       2.00  0.477576E-01 
       3.00  0.462998E-01 
       4.00  0.452850E-01 
       5.00  0.225196E-01 
       6.00  0.407404E-01 
       7.00  0.771257E-01 
       8.00  0.109558E+00 
       9.00  0.996785E-01 
      10.00  0.883875E-01 
      11.00  0.886041E-01 
      12.00  0.112221E+00 
      13.00  0.673883E-01 
      14.00  0.543406E-01 
      15.00  0.764393E-01 
      16.00  0.112102E+00 
      17.00  0.987514E-01 
      18.00  0.764381E-01 
      19.00  0.696656E-01 
      20.00  0.758529E-01 
      21.00  0.833444E-01 
      22.00  0.133775E+00 
      23.00  0.831362E-01 
      24.00  0.703353E-01 
      25.00  0.927732E-01 
      26.00  0.134671E+00
      27.00  0.153958E+00 
      28.00  0.172927E+00 
      29.00  0.188568E+00 
      30.00  0.201121E+00 
      31.00  0.259256E+00 
      32.00  0.186185E+00 
      33.00  0.175990E+00 
      34.00  0.134911E+00 
      35.00  0.103000E+00 
      36.00  0.122606E+00 
      37.00  0.102306E+00 
      38.00  0.103188E+00 
      39.00  0.748922E-01 
      40.00  0.101543E+00 
      41.00  0.109393E+00 
      42.00  0.128556E+00 
      43.00  0.133609E+00 
      44.00  0.138474E+00 
      45.00  0.998585E-01 
      46.00  0.847674E-01 
      47.00  0.949405E-01 
      48.00  0.883886E-01 
      49.00  0.113416E+00 
      50.00  0.105023E+00 
      51.00  0.119045E+00 
      52.00  0.136198E+00 
      53.00  0.748533E-01 
      54.00  0.923844E-01 
      55.00  0.908671E-01 
C
*     SPLINE U3
       0.00 0.751222E-01
       1.00 0.734850E-01
       2.00 0.710862E-01
       3.00 0.764040E-01
       4.00 0.737176E-01
       5.00 0.396349E-01
       6.00 0.709229E-01
       7.00 0.294686E+00
       8.00 0.395967E+00
       9.00 0.400982E+00
      10.00 0.455260E+00
      11.00 0.308184E+00
      12.00 0.249956E+00
      13.00 0.462068E+00
      14.00 0.315084E+00
      15.00 0.333281E+00
      16.00 0.265063E+00
      17.00 0.238043E+00
      18.00 0.166604E+00
      19.00 0.235349E+00
      20.00 0.143919E+00
      21.00 0.200023E+00
      22.00 0.196998E+00
      23.00 0.144200E+00
      24.00 0.209683E+00
      25.00 0.231915E+00
      26.00 0.191542E+00
      27.00 0.200301E+00
      28.00 0.315603E+00
      29.00 0.390381E+00
      30.00 0.366612E+00
      31.00 0.352035E+00
      32.00 0.341620E+00
      33.00 0.168738E+00
      34.00 0.147557E+00
      35.00 0.167404E+00
      36.00 0.205880E+00
      37.00 0.190816E+00
      38.00 0.214948E+00
      39.00 0.161512E+00
      40.00 0.177847E+00
      41.00 0.226720E+00
      42.00 0.252270E+00
      43.00 0.222279E+00
      44.00 0.153880E+00
      45.00 0.136291E+00
      46.00 0.129953E+00
      47.00 0.181832E+00
      48.00 0.161392E+00
      49.00 0.352270E+00
      50.00 0.288167E+00
      51.00 0.291361E+00
      52.00 0.242831E+00
      53.00 0.145409E+00
      54.00 0.134204E+00
      55.00 0.121548E+00
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A1, A2, A31, A32, R, M1, M2, M3, Y1, Y2, Y3, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P = A1*R*Y1 - C*A31*Y1*Y1*Y3/(Y1 + Y2) - (T1 + M1 + U1(T))*Y1
C
*     FUNCTION Y2P
      Y2P = A2*R*Y2 - C*A32*Y2*Y2*Y3/(Y1 + Y2) - (T2 + M2 + U2(T))*Y2 
C
*     FUNCTION Y3P
      AA31 = A31*H
      AA32 = A32*H
      Y3P = C*AA31*Y1*Y1*Y3/(Y1 + Y2) + C*AA32*Y2*Y2*Y3/(Y2 + Y2)
     /    - (T3 + M3 + U3(T))*Y3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = 466.3
C
*     FUNCTION Y20
      Y20 = 159.7
C
*     FUNCTION Y30
      Y30 = 76.1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1 
C
*     FUNCTION Y2FIT
      Y2FIT = Y2 
C
*     FUNCTION Y3FIT
      Y3FIT = Y3 
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = 0.0
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C