C
C------------------------------------------------------
C
C     Problem:    FILTWASH
C
C     Date:       12.02.2001
C
C------------------------------------------------------
C
*     SET OF INDICES
      IND=1..20
C
C------------------------------------------------------
C
*     REAL CONSTANT
      C0=0   
      CI=1     
      L=4.3E-2
      E=0.85   
      N=2      
      K=1        
      G=(1-E)/E     
      M=(1-N)/N
      H=K*(CI**M)/N
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      DL1, U1, C, C_x, C_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION C_t 
      U=U1*1E-4
      DL=DL1*1E-8
      P=DL/(U*L) 
      DN=1/P
      IF (C.GT.0) THEN
        C_t = (DL*C_xx - U*C_x)/(1+H*G*C**M)
      ELSE
        C_t = (DL*C_xx - U*C_x)
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION C_0
      C_0 = CI
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION C_left
      C_left = C0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION C_x_right
      C_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION FIT(I), I IN IND
      FIT(I) = C
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
